
# Figure 4 - MaxQuant #
#######################


library(plyr)
library(dplyr)
library(stringr)
library(useful)
library("data.table")
library("conflicted")
library(reshape2)
conflict_prefer("mutate", "dplyr")
suppressPackageStartupMessages(library("tidyverse"))
conflict_prefer("filter", "dplyr")
library(ggplot2)
library(dplyr)
library(epiDisplay)
library(gmodels)

source('D:/Pipeline comparisons/Writing/R Functions/GBS_Function.R')


Adjusted_PXD000923 <- read.csv("D:/Pipeline comparisons/Writing/Data/MQ/Rice/pform/MQ_PXD000923A_pform.csv")
Adjusted_PXD002222 <- read.csv("D:/Pipeline comparisons/Writing/Data/MQ/Rice/pform/MQ_PXD002222A_pform.csv")
Adjusted_PXD002756 <- read.csv("D:/Pipeline comparisons/Writing/Data/MQ/Rice/pform/MQ_PXD002756A_pform.csv")
Adjusted_PXD004705 <- read.csv("D:/Pipeline comparisons/Writing/Data/MQ/Rice/pform/MQ_PXD004705A_pform.csv")
Adjusted_PXD004939 <- read.csv("D:/Pipeline comparisons/Writing/Data/MQ/Rice/pform/MQ_PXD004939A_pform.csv")
Adjusted_PXD005241 <- read.csv("D:/Pipeline comparisons/Writing/Data/MQ/Rice/pform/MQ_PXD005241A_pform.csv")
Adjusted_PXD012764 <- read.csv("D:/Pipeline comparisons/Writing/Data/MQ/Rice/pform/MQ_PXD012764A_pform.csv")
Adjusted_PXD019291 <- read.csv("D:/Pipeline comparisons/Writing/Data/MQ/Rice/pform/MQ_PXD019291A_pform.csv")


Adjusted_PXD000923_01 <- Adjusted_PXD000923[1:max(which(Adjusted_PXD000923$FLR_Adj_Score<=0.01)),]
Adjusted_PXD002222_01 <- Adjusted_PXD002222[1:max(which(Adjusted_PXD002222$FLR_Adj_Score<=0.01)),]
Adjusted_PXD002756_01 <- Adjusted_PXD002756[1:max(which(Adjusted_PXD002756$FLR_Adj_Score<=0.01)),]
Adjusted_PXD004705_01 <- Adjusted_PXD004705[1:max(which(Adjusted_PXD004705$FLR_Adj_Score<=0.01)),]
Adjusted_PXD004939_01 <- Adjusted_PXD004939[1:max(which(Adjusted_PXD004939$FLR_Adj_Score<=0.01)),]
Adjusted_PXD005241_01 <- Adjusted_PXD005241[1:max(which(Adjusted_PXD005241$FLR_Adj_Score<=0.01)),]
Adjusted_PXD012764_01 <- Adjusted_PXD012764[1:max(which(Adjusted_PXD012764$FLR_Adj_Score<=0.01)),]
Adjusted_PXD019291_01 <- Adjusted_PXD019291[1:max(which(Adjusted_PXD019291$FLR_Adj_Score<=0.01)),]

Adjusted_PXD000923_05 <- Adjusted_PXD000923[1:max(which(Adjusted_PXD000923$FLR_Adj_Score<=0.05)),]
Adjusted_PXD002222_05 <- Adjusted_PXD002222[1:max(which(Adjusted_PXD002222$FLR_Adj_Score<=0.05)),]
Adjusted_PXD002756_05 <- Adjusted_PXD002756[1:max(which(Adjusted_PXD002756$FLR_Adj_Score<=0.05)),]
Adjusted_PXD004705_05 <- Adjusted_PXD004705[1:max(which(Adjusted_PXD004705$FLR_Adj_Score<=0.05)),]
Adjusted_PXD004939_05 <- Adjusted_PXD004939[1:max(which(Adjusted_PXD004939$FLR_Adj_Score<=0.05)),]
Adjusted_PXD005241_05 <- Adjusted_PXD005241[1:max(which(Adjusted_PXD005241$FLR_Adj_Score<=0.05)),]
Adjusted_PXD012764_05 <- Adjusted_PXD012764[1:max(which(Adjusted_PXD012764$FLR_Adj_Score<=0.05)),]
Adjusted_PXD019291_05 <- Adjusted_PXD019291[1:max(which(Adjusted_PXD019291$FLR_Adj_Score<=0.05)),]


AllRice_pform_Max<-dplyr::bind_rows(Adjusted_PXD000923, Adjusted_PXD002222, Adjusted_PXD002756, Adjusted_PXD004705,
                                    Adjusted_PXD004939, Adjusted_PXD005241, Adjusted_PXD012764, Adjusted_PXD019291)

AllRice_pform_Max_01<-dplyr::bind_rows(Adjusted_PXD000923_01, Adjusted_PXD002222_01, Adjusted_PXD002756_01, Adjusted_PXD004705_01,
                                       Adjusted_PXD004939_01, Adjusted_PXD005241_01, Adjusted_PXD012764_01, Adjusted_PXD019291_01)

AllRice_pform_Max_05<-dplyr::bind_rows(Adjusted_PXD000923_05, Adjusted_PXD002222_05, Adjusted_PXD002756_05, Adjusted_PXD004705_05,
                                       Adjusted_PXD004939_05, Adjusted_PXD005241_05, Adjusted_PXD012764_05, Adjusted_PXD019291_05)


AllRice_pform_Max$New_FLR_PEP <-AllRice_pform_Max$FLR_Adj_Score
AllRice_pform_Max_01$New_FLR_PEP <-AllRice_pform_Max_01$FLR_Adj_Score
AllRice_pform_Max_05$New_FLR_PEP <-AllRice_pform_Max_05$FLR_Adj_Score

AllRice_pform_Max_Final <- GSB_Function(AllRice_pform_Max_01,AllRice_pform_Max_05)

str(AllRice_pform_Max_Final)


RiceY <- AllRice_pform_Max_Final[(AllRice_pform_Max_Final$Amino=="Y") & (AllRice_pform_Max_Final$cat != "Bronze"),]


CrossTable(AllRice_pform_Max_Final$cat, AllRice_pform_Max_Final$Amino)

df2 <- data.frame(Amino=rep(c("S", "T", "Y", "A"), each=3),
                  Level=rep(c("Gold:2822", "Silver:5730", "Bronze:10147"),4),
                  Unique_sites=c(2586, 5179, 8512, 232, 518, 1225, NA, 18, 109, 1, 15, 301))
head(df2)

# Add 3 to gold manually

ggplot(data=df2, aes(x=Level, y=Unique_sites, fill=Amino)) +
  geom_bar(stat="identity")

p <- df2 %>%
  dplyr::arrange(Unique_sites) %>%
  mutate(Level = factor(Level, levels=c("Gold:2822", "Silver:5730", "Bronze:10147"))) %>%
  ggplot(aes(x=Level, y=Unique_sites, fill=Amino)) +
  geom_bar(stat="identity") +
  xlab("") 

p + geom_text(aes(label = Unique_sites), position = position_stack(vjust =  0.8), size = 5) + 
  theme(text = element_text(size = 20))

write.csv(AllRice_pform_Max_Final, "D:/Pipeline comparisons/Writing/Data/GSB/Rice/MQ_GSB.csv", row.names=FALSE)